﻿<################################################# 起動サンプル2  2023/10/01
●スクリプト説明
１．本スクリプト起動と同時にバックグラウンドにて読取ツールを立ち上げます。
２．フォーム上で 日付、作業者 を入力します。
３．機器での読取処理を行い読取ツールが出力したファイルを一定間隔でチェックします。データが追加されると取り込んで表示をします。
４．編集ボタンにて、読取データを編集、追加、削除できます。ただし、機器での読取が停止している場合に限ります。
５．全ての読取処理が終わった後、ファイル出力ボタンを押すと読取データを出力します。
　　この際に読取ツールで作成されたデータは削除され、表示データもクリアされます。
６．終了ボタンを押すと本スクリプトは終了します。
　　ファイル出力せずに表示データが残っている場合は、次回の起動時に続きから読取ができます。

本スクリプトをバッチまたは、ショートカットでの起動する場合は下記のコマンドを使用します。
  powershell.exe -WindowStyle Hidden -ExecutionPolicy RemoteSigned -command ".\起動サンプル_PS.ps1"
#>
################################################## パラメータ
$ToolFilePath = ".\ApTool.ps1"     #ツール ファイルパス
$InputFilePath = ".\ReadData.txt"  #入力ファイルパス（ツールが出力した読取データファイル）
$OutputFileName = "Output.csv"     #出力ファイル名（出力時にはファイル名の先頭に作成日時が追加されます）
$Separater = ","                   #出力ファイルのセパレータ文字 タブ:"`t"
$UpdateInterval = 500              #読取データ更新チェック間隔(ms)。処理負荷が高い場合は長めに設定します。

################################################## # アセンブリのロード
Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

################################################## ファイル処理
#---+---+---+---+---+---+---+---+---+---+ 読取データファイル取り込み・表示
Function InputReadDataFnc() {
    If ((Test-Path $InputFilePath) -and (Get-Content $InputFilePath).count -gt 0) {    #読取データファイル存在確認 ファイル内データ有無確認
        $Add = (Get-Content $InputFilePath).count - $ReadCount
        If ($Add -gt 0 -and $ReadCount -gt 0) {
            #増加分のデータのみ
            $Num = $ReadCount
        } Else {
            #全データを再取り込み
            $Grid.Rows.Clear()    #データグリッドビュー項目をすべて削除
            $Add = (Get-Content $InputFilePath).count
            $Num = 0
        }
        Foreach ($Str in Get-Content $InputFilePath -Encoding default -tail $Add) {
            [void]$Grid.Rows.Add(("{0:D4}" -f ++$Num), "$Str")    #Noを0バディングして、データグリッドビューへレコード追加
        }
    } Else {
        $Grid.Rows.Clear()    #データグリッドビュー項目をすべて削除
        $Num = 0
    }
    $Grid.CurrentCell = $Grid[2, 0]    #範囲外セルを指定し非選択にする
    $Grid.AllowUserToAddRows = $False    #新規追加行を非表示
    If ($Num -gt 0) { $Grid.FirstDisplayedScrollingRowIndex = $Grid.Rows.Count - 1 }    #最下行を表示
    $Grid.ReadOnly = $True    #読取専用
    $CountLabel.Text = $Num    #読取枚数表示
    $script:ReadCount = $Num    #読取データ数更新
}

#---+---+---+---+---+---+---+---+---+---+ 読取データファイル更新
Function UpdateReadDataFnc() {
    DeleteReadDataFnc    #読取データファイル削除
    Foreach ($Item in $Grid.Rows) {
        If ($Item.Cells[1].Value.Length -ne 0) {    #データ未入力行は無視
            $Line = $Item.Cells[1].Value    #データ
            Write-Output $Line | Out-File $InputFilePath -Encoding default -Append    #ファイルに追記
        }
    }
}

#---+---+---+---+---+---+---+---+---+---+ 読取データファイル削除
Function DeleteReadDataFnc() {
    If (Test-Path $InputFilePath) {    #読取データファイル存在確認
        Remove-Item $InputFilePath    #読取データファイル削除
    }
}

#---+---+---+---+---+---+---+---+---+---+ 出力ファイル
Function OutputFnc() {
    Foreach ($Item in $Grid.Rows) {
        If ($Item.Cells[1].Value.Length -ne 0) {    #データ未入力行は無視

            #出力レコード
            #$Line = $Item.Cells[1].Value    #データのみ
            #$Line = ($Item.Cells[0].Value -replace "\b0+") + $Separater + $Item.Cells[1].Value    #No(0サプレス), データ
            $Line = ([Datetime]$Date.Text).ToString("yyyy-MM-dd") + $Separater + $Combo.Text + $Separater + $Item.Cells[1].Value    #入力日付, 作業者, データ

            $FileName = (Get-Date -Format "yyMMdd-HHmmss") + $OutputFileName    #出力ファイル名
            Write-Output $Line | Out-File $FileName -Encoding default -Append    #ファイルに追記
        }
    }
}

################################################## フォーム
#メインフォーム
$Form = New-Object System.Windows.Forms.Form
$Form.Text = "読取処理"    #フォームタイトル
$Form.Size = "400, 400"
$Form.StartPosition = "CenterScreen"  #WindowsDefaultLocation  WindowsDefaultBounds  CenterParent
$Form.MaximizeBox = $false    #最大化ボタン
$Form.MinimizeBox = $false    #最小化ボタン

#---+---+---+---+---+---+---+---+---+---+ タイトル
#ラベル
$TitleLabel = New-Object System.Windows.Forms.Label
$TitleLabel.Location = "10, 20"
$TitleLabel.AutoSize = $true            #文字サイズに合わせ自動調整
$TitleLabel.Font = "'ＭＳ ゴシック', 20"
$TitleLabel.Text = "伝票読取"
$Form.Controls.Add($TitleLabel)

#---+---+---+---+---+---+---+---+---+---+ 読取枚数
#ラベル
$CountLabel = New-Object System.Windows.Forms.Label
$CountLabel.Location = "220, 20"
#$CountLabel.Location = "300, 20"
#$CountLabel.AutoSize = $false            #文字サイズに合わせ自動調整
$CountLabel.TextAlign = "MiddleRight"    #右寄せ
$CountLabel.Font = "'ＭＳ ゴシック', 20"
#$CountLabel.BackColor = "white"
$CountLabel.ForeColor = "blue"
$CountLabel.Text = 0
$Form.Controls.Add($CountLabel)

#---+---+---+---+---+---+---+---+---+---+ 日付入力
# DatetimePickerコントロールの作成
$Date = New-Object System.Windows.Forms.DatetimePicker
$Date.location = "10, 65"
$Date.Size = "150, 25"
$Date.Font = "'ＭＳ ゴシック',12"
$Date.Format = "Long"
$Form.Controls.Add($Date)
#結果取得方法
#$Result = $Date.Text    #日付取得

#---+---+---+---+---+---+---+---+---+---+ 作業者入力
# コンボボックス
$Combo = New-Object System.Windows.Forms.Combobox
$Combo.Location = "170, 60"
$Combo.size = "140, 30"
$Combo.DropDownStyle = "DropDown"    #DropDown、DropDownList、Simleから選択し変更可能
$Combo.FlatStyle = "standard"
$Combo.Font = "'ＭＳ ゴシック',16"
#$Combo.BackColor = "#005050"
#$Combo.ForeColor = "white"
# コンボボックスへの項目追加
[void] $Combo.Items.Add("鈴木")
[void] $Combo.Items.Add("佐藤")
[void] $Combo.Items.Add("山田")
[void] $Combo.Items.Add("伊藤")
[void] $Combo.Items.Add("ゲスト")
$form.Controls.Add($Combo) 
#結果取得方法
#$Result = $Combo.Text    #作業者取得

#---+---+---+---+---+---+---+---+---+---+ 読取データ
# データグリッドビュー
$Grid = New-Object System.Windows.Forms.DataGridView
$Grid.Location = "10, 100"
$Grid.Size = "360, 210"
$Grid.Anchor = (([System.Windows.Forms.AnchorStyles]::Left)`
              -bor ([System.Windows.Forms.AnchorStyles]::Top)`
              -bor ([System.Windows.Forms.AnchorStyles]::Right)`
              -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$Grid.AutoSizeColumnsMode = "Fill"  #表示領域の幅いっぱいに表示。"AllCells"ですべてのセルの内容に合わせ調整
$Grid.RowHeadersVisible = $False    #左端列の非表示
# 列タイトル
$Grid.ColumnCount = 2    # 列数を指定
$Grid.Columns[0].Name = "No"  #項目名1
$Grid.Columns[0].Width = 45
$Grid.Columns[1].Name = "データ"  #項目名2
$Form.Controls.Add($Grid)

#---+---+---+---+---+---+---+---+---+---+ 各種ボタン
#ボタン 読取開始／停止
$ReadButton = New-Object System.Windows.Forms.Button
$ReadButton.Location = "320, 20"
$ReadButton.Size = "50, 70"
$ReadButton.Text = "読取`n開始"
$ReadButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Right)`
               -bor ([System.Windows.Forms.AnchorStyles]::Top))    #位置固定(画面サイズ変更時など)
$Form.Controls.Add($ReadButton)

#ボタン 編集
$EditButton = New-Object System.Windows.Forms.Button
$EditButton.Location = "10, 320"
$EditButton.Size = "40, 23"
$EditButton.Text = "編集"
$EditButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Left)`
               -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$Form.Controls.Add($EditButton)

#ボタン 更新
$UpdateButton = New-Object System.Windows.Forms.Button
$UpdateButton.Location = "55, 320"
$UpdateButton.Size = "40, 23"
$UpdateButton.Text = "更新"
$UpdateButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Left)`
               -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$Form.Controls.Add($UpdateButton)
$UpdateButton.Enabled = $False    #起動時無効

#ボタン キャンセル
$CancelButton = New-Object System.Windows.Forms.Button
$CancelButton.Location = "100, 320"
$CancelButton.Size = "75, 23"
$CancelButton.Text = "キャンセル"
$CancelButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Left)`
                   -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$Form.Controls.Add($CancelButton)
$CancelButton.Enabled = $False    #起動時無効

#ボタン 出力
$OutputButton = New-Object System.Windows.Forms.Button
$OutputButton.Location = "250, 320"
$OutputButton.Size = "75, 23"
$OutputButton.Text = "ファイル出力"
$OutputButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Right)`
               -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$Form.Controls.Add($OutputButton)

#ボタン 終了
$EndButton = New-Object System.Windows.Forms.Button
$EndButton.Location = "330,320"
$EndButton.Size = "40,23"
$EndButton.Text = "終了"
$EndButton.Anchor = (([System.Windows.Forms.AnchorStyles]::Right)`
                   -bor ([System.Windows.Forms.AnchorStyles]::Bottom))    #位置固定(画面サイズ変更時など)
$EndButton.DialogResult = [System.Windows.Forms.DialogResult]::OK    #フォーム終了結果
$Form.Controls.Add($EndButton)

#フォームを表示直後の処理
$Form.Add_Shown({
    $Combo.Select()    #作業者入力にフォーカスを設定
})

################################################## ボタンクリック処理
#---+---+---+---+---+---+---+---+---+---+ 読取
$ReadButton.Add_Click({
    If ($ReadButton.Text -ne "停止") {
        If (-not(Test-Path ".\ApTool_実行中.txt")) {    #ツールの実行中ファイル確認
            ToolStartFnc    #読取ツール起動
        }
        $ReadButton.Text = "停止"
    } Else {
        ToolEndFnc    #読取ツール終了
        $ReadButton.Text = "読取`n開始"
    }
})

#---+---+---+---+---+---+---+---+---+---+ 編集
$EditButton.Add_Click({
    [void][System.Windows.Forms.MessageBox]::Show("データの編集は、必ず読取停止中に行ってください。", "確認")
    $Grid.ReadOnly = $False    #データグリッドビュー編集可
    $EditButton.Enabled = $False     #編集ボタン無効
    $UpdateButton.Enabled = $True    #更新ボタン有効
    $CancelButton.Enabled = $True    #キャンセルボタン有効
    $OutputButton.Enabled = $False   #出力ボタン無効
    $Grid.AllowUserToAddRows = $True    #新規追加行を表示
    $Grid.CurrentCell = $Grid[1, ($Grid.Rows.Count - 1)]    #最終行データをカレントにする
    $Grid.Select()    #フォーカス移動
})

#---+---+---+---+---+---+---+---+---+---+ 更新
$UpdateButton.Add_Click({
    UpdateReadDataFnc    #表示データを読取データファイルへ反映
    $Grid.ReadOnly = $True    #データグリッドビュー読取専用
    $EditButton.Enabled = $True       #編集ボタン有効
    $UpdateButton.Enabled = $False    #更新ボタン有効
    $CancelButton.Enabled = $False    #キャンセルボタン有効
    $OutputButton.Enabled = $True     #出力ボタン有効
    $OutputButton.Select()    #フォーカス移動
    $script:ReadCount = -1    #読取データ再読み込み
})

#---+---+---+---+---+---+---+---+---+---+ キャンセル
$CancelButton.Add_Click({
    $Grid.Rows.Clear()    #データグリッドビュー項目をすべて削除
    $Grid.ReadOnly = $True    #データグリッドビュー読取専用
    $EditButton.Enabled = $True       #編集ボタン有効
    $UpdateButton.Enabled = $False    #更新ボタン有効
    $CancelButton.Enabled = $False    #キャンセルボタン有効
    $OutputButton.Enabled = $True     #出力ボタン有効
    $OutputButton.Select()    #フォーカス移動
    $script:ReadCount = -1    #読取データ再読み込み
})

#---+---+---+---+---+---+---+---+---+---+ 出力
$OutputButton.Add_Click({
    #確認ダイアログ
    $result = [System.Windows.Forms.MessageBox]::Show("ファイル出力しますか？", "確認", "YesNo", "Question", "Button2")  #メッセージボックス
    If ($result -eq "Yes") {
        OutputFnc    #ファイル出力
        [System.Windows.Forms.MessageBox]::Show("ファイルを出力しました。", "確認")
        DeleteReadDataFnc    #読取データファイル削除
        $Grid.Rows.Clear()    #データグリッドビュー項目をすべて削除
        $CountLabel.Text = 0
        $script:ReadCount = 0    #読取データクリア
    }
    $EndButton.Select()    #フォーカス移動
})

################################################## タイマ処理
$Timer = New-Object System.Windows.Forms.Timer
$Timer.Interval = $UpdateInterval    #タイマ処理間隔(ms)

#---+---+---+---+---+---+---+---+---+---+ 処理
$Time = {
    If (Test-Path $InputFilePath) {    #読取データファイル存在確認
        $FileLen = (Get-Content $InputFilePath).Count    #読取データファイル行数
    } Else {
        $FileLen = 0
    }
    If($FileLen -ne $ReadCount) {    #データ数が更新されたか確認
        InputReadDataFnc    #読取データファイルを読込
    }
}

#---+---+---+---+---+---+---+---+---+---+
$Timer.Add_Tick($Time)

################################################## 読取ツール起動処理
#---+---+---+---+---+---+---+---+---+---+ ツール起動
Function ToolStartFnc() {
    Start-Process -FilePath powershell.exe -ArgumentList "-command $ToolFilePath" -windowstyle Minimized
}

#---+---+---+---+---+---+---+---+---+---+ ツール終了
Function ToolEndFnc() {
    If (Test-Path ".\ApTool_実行中.txt") {    #ツールの実行中ファイル確認
        Remove-Item ".\ApTool_実行中.txt"    #実行中ファイル削除
    }
}

################################################## スタート処理
$ReadCount = -1    #読取データ数 初期化（データ再読み込み）

If ((Test-Path $InputFilePath) -and (Get-Content $InputFilePath).count -gt 0) {    #読取データファイル存在確認 ファイル内データ有無確認
    $result = [System.Windows.Forms.MessageBox]::Show("前回の読取データが存在します。続きから読取しますか？", "確認", "YesNo", "Question", "Button1")  #メッセージボックス
    If ($result -eq "No") {
        [System.Windows.Forms.MessageBox]::Show("読取データファイルを削除しました。", "確認")
        DeleteReadDataFnc    #読取データファイル削除
    }
}

################################################## メイン処理
$Timer.Start()    #タイマー起動

#---+---+---+---+---+---+---+---+---+---+ フォーム表示
#$Form.Topmost = $true    #フォームを常に手前に表示
$Form.TopLevel = $true    #起動時は最前面に表示
$Result = $Form.ShowDialog()    #フォームを表示　フォームが閉じられるまで処理はストップ

################################################## 終了処理
ToolEndFnc    #読取ツール終了
$Timer.Stop()    #タイマー終了
